/*********************************************************************************
/*
/*  KillMutex :: cPrivilege.j.cpp
/*
/*  Copyright 2008-2021 Robert Sacks.  https://mojoware.org
/*
/*********************************************************************************/

#include "stdafx.h"
#include <assert.h>
#include "cPrivilege.j.h"

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//  CONSTRUCTOR
//----------------------------------------------------------------------------------------------------------------------
cPrivilege::cPrivilege ( const wchar_t * pArgPrivilegeName )
{
	size_t size = 1 + wcslen ( pArgPrivilegeName );

	pPrivilegeName = new wchar_t [ size ];

	wcscpy_s ( pPrivilegeName, size, pArgPrivilegeName );

	if ( get_thread_token ( &hToken ) )
		set_privilege ( hToken, pPrivilegeName /* SE_DEBUG_NAME */, TRUE );

	else
	{
		// error
	}
}


//----------------------------------------------------------------------------------------------------------------------
// DESTRUCTOR
//----------------------------------------------------------------------------------------------------------------------
cPrivilege::~cPrivilege ()
{
	set_privilege ( hToken, pPrivilegeName, FALSE );

	delete [] pPrivilegeName;

	if ( hToken )
		CloseHandle ( hToken );
}


//----------------------------------------------------------------------------------------------------------------------
//  SET PRIVILEGE
//  Microsoft code from MSDN
//----------------------------------------------------------------------------------------------------------------------
BOOL set_privilege	(
    HANDLE hToken,          // access token handle
    LPCTSTR lpszPrivilege,  // name of privilege to enable/disable
    BOOL bEnablePrivilege   // to enable or disable privilege
    ) 
{
	if ( ! hToken )
		return FALSE;

	TOKEN_PRIVILEGES tp;
	LUID luid;

	if ( !LookupPrivilegeValue( 
        NULL,            // lookup privilege on local system
        lpszPrivilege,   // privilege to lookup 
        &luid ) )        // receives LUID of privilege
	{

#if 0
			LOG_SYSTEM_ERROR_T ( "LookupPrivilegeValue" );
#endif
		return FALSE; 
	}

	tp.PrivilegeCount = 1;
	tp.Privileges[0].Luid = luid;

	if (bEnablePrivilege)
		tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	else
		tp.Privileges[0].Attributes = 0;

	// Enable the privilege or disable all privileges.

	if ( !AdjustTokenPrivileges(
		 hToken, 
		 FALSE, 
		 &tp, 
		sizeof(TOKEN_PRIVILEGES), 
		(PTOKEN_PRIVILEGES) NULL, 
		(PDWORD) NULL) )
	{
#if 0
			LOG_SYSTEM_ERROR_T ( "AdjustTokenPrivileges" );
#endif

		return FALSE; 
	} 

	if (GetLastError() == ERROR_NOT_ALL_ASSIGNED)

	{
#if 0
		LOG ( "The token does not have the specified privilege.");
#endif
		return FALSE;
	} 

	return TRUE;
}


//----------------------------------------------------------------------------------------------------------------------
//  GET THREAD TOKEN
//----------------------------------------------------------------------------------------------------------------------
bool get_thread_token ( HANDLE * phToken)
{
	if(!OpenThreadToken(GetCurrentThread(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, FALSE, phToken ) )
    {
        if (GetLastError() == ERROR_NO_TOKEN)
        {
            if ( ! ImpersonateSelf(SecurityImpersonation))
				return false;

            if ( ! OpenThreadToken(GetCurrentThread(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, FALSE, phToken ) )
			{
                return false;
            }
		}
     }
	
	return true;
}






