/***********************************************************************************************************************
/*
/*  cCriticalSectionRaii.j.h
/*
/*  Begun 2020 dec 16
/*
/*  Copyright 2020 Robert Sacks. https://mojoware.org
/*
/**********************************************************************************************************************/

#pragma once

#include <Windows.h>

//----------------------------------------------------------------------------------------------------------------------
// CLASS
// This doesn't create a critical section.
// It only wraps Enter and Leave so leaving is automatic when a function returns.
//----------------------------------------------------------------------------------------------------------------------

class cCriticalSectionRaii
{

public:

	cCriticalSectionRaii ( CRITICAL_SECTION &a ) : _pCs(&a) { EnterCriticalSection ( _pCs ); }

	~cCriticalSectionRaii () { LeaveCriticalSection ( _pCs ); }

private:

	CRITICAL_SECTION * _pCs;
};


