/***********************************************************************************************************************
/*
/*	cFileMapView.j.cpp
/*
/*	Copyright 2018-19 Robert Sacks.  https://mojoware.org
/*
/**********************************************************************************************************************/

#include "stdafx.h"
#define WIN32_LEAN_AND_MEAN
#include <Windows.h>
#include "cFileMapView.j.h"

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//  DTOR
//----------------------------------------------------------------------------------------------------------------------
cFileMapView :: ~cFileMapView () 
{ 
	UnmapViewOfFile ( pMem ); CloseHandle ( hMap ); CloseHandle ( hFile ); 
}


//-----------------------------------------------------------------------------------------------------------------------
//   OPEN
//-----------------------------------------------------------------------------------------------------------------------
bool cFileMapView :: open ( const wchar_t * pPath )
{
	hFile = CreateFile ( pPath, GENERIC_READ,FILE_SHARE_READ,NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);

	if ( INVALID_HANDLE_VALUE == hFile )
		return false;

	LARGE_INTEGER liFileSize = {0};

	if ( ! GetFileSizeEx ( hFile, &liFileSize ) )
		return false;

	uFileSize = liFileSize.QuadPart;

	hMap = CreateFileMapping ( hFile, NULL, PAGE_READONLY, 0, 0, NULL );

	if ( 0 == hMap )
		return false;

	pMem = MapViewOfFile ( hMap, FILE_MAP_READ, 0, 0, 0 );

	return ( pMem ? true : false );
}

