/***********************************************************************************************************************
/*
/*  format_int_with_commas.j.cpp
/*
/*	Copyright 2010-20 Robert Sacks. https://mojoware.org
/*
/**********************************************************************************************************************/

#include "stdafx.h"
#include "format_int_with_commas.j.h"
#include <strsafe.h>
#include "sprintf_safe.j.h"

//======================================================================================================================
//  PROTYPES
//======================================================================================================================

static wchar_t * format_int_with_commas_sub ( wchar_t * pRet, size_t sz, uint64_t i );

//======================================================================================================================
//  CODE
//======================================================================================================================

//----------------------------------------------------------------------------------------------------------------------
//  FORMAT INT WITH COMMAS
//----------------------------------------------------------------------------------------------------------------------
wchar_t * format_int_with_commas ( wchar_t * pRet, size_t sz, uint64_t i )
{
	pRet [ 0 ] = 0;
	return format_int_with_commas_sub ( pRet, sz, i );
}


//----------------------------------------------------------------------------------------------------------------------
//  FORMAT INT WITH COMMAS -- SUB
//----------------------------------------------------------------------------------------------------------------------
wchar_t * format_int_with_commas_sub ( wchar_t * pRet, size_t sz, uint64_t i )
{
	if ( i < 1000 )
	{
		wchar_t t [ 256 ];
		sprintf_safe ( t, sizeof ( t )/sizeof ( wchar_t ), L"%I64d", i );
		StringCchCat ( pRet, sz, t );
		return pRet;
	}

	format_int_with_commas ( pRet, sz, i / 1000 );

	{
		wchar_t t [ 256 ];
		sprintf_safe ( t, sizeof ( t ), L",%03I64d", i % 1000 );
		StringCchCat ( pRet, sz, t );
	}

	return pRet;
}
