/***********************************************************************************************************************
/*
/*	get_pe_header_time_stamp.j.cpp
/*
/*	Keywords:  coff pe header linker timestamp time date
/*
/*	Copyright Robert Sacks 2017-21.  https://mojoware.org
/*
/**********************************************************************************************************************/

#include "stdafx.h"
#include <Windows.h>
#include "get_pe_header_time_stamp.j.h"
#include "cFileMapView.j.h"
#include <time.h>

//======================================================================================================================
//  CODE
//======================================================================================================================

//-----------------------------------------------------------------------------------------------------------------------
//   GET PE HEADER TIME STAMP
//-----------------------------------------------------------------------------------------------------------------------
bool get_pe_header_time_stamp__current_exe ( DWORD * pSeconds, const wchar_t * pModuleName  )
{
	__try
	{
		IMAGE_DOS_HEADER * pDos = (IMAGE_DOS_HEADER*) GetModuleHandle ( pModuleName );

		if ( IMAGE_DOS_SIGNATURE != pDos->e_magic )
			return false;

		IMAGE_NT_HEADERS * pNt = (IMAGE_NT_HEADERS*)(((BYTE*)pDos) + pDos->e_lfanew);

		if ( IMAGE_NT_SIGNATURE != pNt->Signature )
			return false;

		IMAGE_FILE_HEADER *pHeader = &pNt->FileHeader;

		*pSeconds = pHeader->TimeDateStamp;

		return true;
	}

	__except ( EXCEPTION_EXECUTE_HANDLER )
	{
		return false;
	}
}


//-----------------------------------------------------------------------------------------------------------------------
//   GET PE HEADER TIME STAMP
//-----------------------------------------------------------------------------------------------------------------------
bool get_pe_header_time_stamp ( DWORD * pSeconds, const wchar_t * pPath )
{
	cFileMapView fmv;

	if ( ! fmv.open ( pPath ) )
		return false;

	IMAGE_DOS_HEADER * pDos = (IMAGE_DOS_HEADER*) fmv.pMem;

	if ( IMAGE_DOS_SIGNATURE != pDos->e_magic )
		return false;

	IMAGE_NT_HEADERS * pNt = (IMAGE_NT_HEADERS*)(((BYTE*)pDos) + pDos->e_lfanew);

	if ( IMAGE_NT_SIGNATURE != pNt->Signature )
		return false;

	IMAGE_FILE_HEADER *pHeader = &pNt->FileHeader;

	*pSeconds = pHeader->TimeDateStamp;

	return true;
}


//-----------------------------------------------------------------------------------------------------------------------
//   PE HEADER TIME SECONDS TO STRING
//   Function returns Unix timedate string without the \n 
//-----------------------------------------------------------------------------------------------------------------------
bool pe_header_time_stamp__seconds_to_string ( wchar_t pRet [26], DWORD dwSeconds )
{
	time_t Time = dwSeconds;

	_wctime_s ( pRet, (size_t)26, &Time );

	pRet[24] = 0; // remove /n

	return true;
}


//-----------------------------------------------------------------------------------------------------------------------
//   GET PE HEADER TIME STAMP
//   Function returns Unix timedate string without the \n 
//-----------------------------------------------------------------------------------------------------------------------
bool get_pe_header_time_stamp ( wchar_t pRet [26], const wchar_t * pPath )
{
	DWORD dwSeconds;

	if ( ! get_pe_header_time_stamp ( &dwSeconds, pPath ) )
		return false;

	return pe_header_time_stamp__seconds_to_string ( pRet, dwSeconds );
}


