//*****************************************************
//
//  test_linkage_static.cpp
//
//  2022 apr 07: begun
//
//****************************************************/

#include <Windows.h>
#include <zlib.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <shlwapi.h>

#pragma comment ( lib, "shlwapi.lib" )

//----------------------------------------------------
//  SHOW RESULTS
//----------------------------------------------------
bool show_results ( bool bSuccess )
{
    #ifdef _WIN64
    unsigned uBitness = 64;
#else
    unsigned uBitness = 32;
#endif

#ifdef _DEBUG
    const char * pConfig = "debug";
#else
    const char * pConfig = "release";
#endif

#ifdef __WINDLL
    const char * pLinkage = "DLL";
#else
    const char * pLinkage = "static";
#endif

    const char * pResult = 0;

    if ( bSuccess )
        pResult = "We passed with flying colors.";

    else
        pResult = "We flunked the test.";

    const char * pFilename = PathFindFileNameA ( __FILE__ ); 

    char b [500] = {0};
    sprintf_s ( b, ARRAYSIZE(b), "%u-bit %s %s build\n\n%s\n\n%s",
        uBitness, pConfig, pLinkage, pFilename, pResult );

    MessageBoxA ( 0, b, "Test", MB_OK );

    return bSuccess;
}




//----------------------------------------------------
//  MAIN
//----------------------------------------------------
int main()
{
    const size_t uArraySize = 5000;

    Bytef in [uArraySize] =     {0};
    Bytef comp [uArraySize] =   {0};
    Bytef uncomp [uArraySize] = {0};

    for ( size_t u = 0; u < ARRAYSIZE(in); u++ )
        in[u] = u % 256;

    uLongf uCompLen = ARRAYSIZE ( comp );

    compress ( comp, &uCompLen, in, ARRAYSIZE(in) );

    uLongf uUncompLen = ARRAYSIZE ( uncomp );

    uncompress ( uncomp, &uUncompLen, comp, uCompLen );

    bool bSuccess = show_results (0 == memcmp (uncomp,in,ARRAYSIZE(in)));

    return bSuccess ? 0 : 1;
}
